/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public interface ArmorStandStyleOption {
    public static final int ARMOR_STAND_ALL_SLOTS_DISABLED = 0x3F3F3F;
    public static final BiMap<ResourceLocation, ArmorStandStyleOption> OPTIONS_REGISTRY = HashBiMap.create();

    public String getTranslationId();

    default public Component getComponent() {
        return Component.m_237115_((String)("armorstatues.screen.style." + this.getTranslationId()));
    }

    default public Component getDescriptionComponent() {
        return Component.m_237115_((String)("armorstatues.screen.style." + this.getTranslationId() + ".description"));
    }

    public void setOption(ArmorStand var1, boolean var2);

    public boolean getOption(ArmorStand var1);

    public void toTag(CompoundTag var1, boolean var2);

    default public boolean allowChanges(Player player) {
        return true;
    }

    default public ResourceLocation getId() {
        return Objects.requireNonNull((ResourceLocation)OPTIONS_REGISTRY.inverse().get((Object)this), "Armor stand style option %s has not been registered".formatted(this.getTranslationId()));
    }

    public static void register(ResourceLocation id, ArmorStandStyleOption styleOption) {
        if (OPTIONS_REGISTRY.containsValue((Object)styleOption) || OPTIONS_REGISTRY.put((Object)id, (Object)styleOption) != null) {
            throw new IllegalStateException("Attempted to register duplicate armor stand style option for id %s".formatted(id));
        }
    }

    public static ArmorStandStyleOption get(ResourceLocation id) {
        return Objects.requireNonNull((ArmorStandStyleOption)OPTIONS_REGISTRY.get((Object)id), "No armor stand style option registered for id %s".formatted(id));
    }

    public static boolean getArmorStandData(ArmorStand armorStand, int offset) {
        return ((Byte)armorStand.m_20088_().m_135370_(ArmorStand.f_31524_) & offset) != 0;
    }

    public static void setArmorStandData(ArmorStand armorStand, boolean setting, int offset) {
        armorStand.m_20088_().m_135381_(ArmorStand.f_31524_, (Object)ArmorStandStyleOption.setBit((Byte)armorStand.m_20088_().m_135370_(ArmorStand.f_31524_), offset, setting));
    }

    private static byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }
}

